/*
 * Decompiled with CFR 0.152.
 */
package fr.free.kueny.patrice.pilot;

import fr.free.kueny.patrice.pilot.CockpitConfig;
import fr.free.kueny.patrice.pilot.Pilot;
import fr.free.kueny.patrice.pilot.Plane;
import fr.free.kueny.patrice.pilot.PlaneConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class Cockpit
extends JPanel {
    protected static final Color skyColor = new Color(192, 255, 255);
    protected static final Color groundColor = new Color(128, 64, 64);
    private final Pilot pilot;
    private final JLayeredPane layeredPanel;
    private final CockpitConfig config;
    private NamedImage planeImage;
    private double[] wingTriggers;
    private double[] powerTriggers;
    private double[] speedTriggers;
    private NamedIndicator altIndic;
    private NamedIndicator wingIndic;
    private NamedIndicator angleIndic;
    private NamedIndicator powerIndic;
    private NamedIndicator speedIndic;
    private int planeIndex;
    public Plane plane;

    public Cockpit(Pilot pilot, JLayeredPane layeredPanel, CockpitConfig config, int planeIndex) {
        this.pilot = pilot;
        this.config = config;
        this.layeredPanel = layeredPanel;
        this.planeIndex = planeIndex;
        this.initComponents();
        this.displayPlane();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 0));
        this.planeImage = new NamedImage(this.config.location, Pilot.planeConfigs[this.planeIndex].image_photo);
        this.add(this.planeImage);
        this.powerTriggers = new double[]{-2.147483648E9, 0.0, 0.0, 2.147483647E9};
        Color[] powerColors = new Color[]{Color.red, Color.orange, Color.green};
        this.powerIndic = new NamedIndicator("moteur", Color.gray, this.powerTriggers, powerColors, String.valueOf(this.config.getKeyNames(2)) + " pour r\u00e9duire le moteur, " + this.config.getKeyNames(3) + " pour augmenter le moteur");
        this.powerIndic.updateValue(-2.147483648E9, 0.0);
        this.add(this.powerIndic);
        this.wingTriggers = new double[]{-2.147483648E9, 2.147483647E9};
        Color[] wingColors = new Color[]{skyColor};
        this.wingIndic = new NamedIndicator("manche", groundColor, this.wingTriggers, wingColors, String.valueOf(this.config.getKeyNames(1)) + " pour tirer le manche, " + this.config.getKeyNames(0) + " pour pousser le manche");
        this.wingIndic.updateValue(-2.147483648E9, 0.0);
        this.add(this.wingIndic);
        double[] angleTriggers = new double[]{-1.5707963267948966, 1.5707963267948966};
        Color[] angleColors = new Color[]{skyColor};
        this.angleIndic = new NamedIndicator("horizon", groundColor, angleTriggers, angleColors, "Indique la direction");
        this.angleIndic.updateValue(-1.5707963267948966, 0.0);
        this.add(this.angleIndic);
        this.speedTriggers = new double[]{0.0, 0.0, 0.0, 2.147483647E9};
        Color[] speedColors = new Color[]{Color.green, Color.orange, Color.red};
        this.speedIndic = new NamedIndicator("vitesse", Color.gray, this.speedTriggers, speedColors, "Indique la vitesse");
        this.speedIndic.updateValue(0.0, 0.0);
        this.add(this.speedIndic);
        double[] altTriggers = new double[]{0.0, 20.0, 50.0, 360.0};
        Color[] altColors = new Color[]{Color.red, Color.orange, Color.green};
        this.altIndic = new NamedIndicator("altitude", Color.gray, altTriggers, altColors, "Indique l'altitude");
        this.altIndic.updateValue(0.0, 0.0);
        this.add(this.altIndic);
        this.setBackground(Color.black);
        this.updatePlaneToolTip();
    }

    private void updatePlaneToolTip() {
        String text = this.plane == null ? String.valueOf(this.config.getKeyNames(1)) + " ou " + this.config.getKeyNames(0) + " pour choisir un avion, " + this.config.getKeyNames(3) + " pour le sortir du hangar" : String.valueOf(this.config.getKeyNames(2)) + " pour ranger un avion immobile au hangar, " + this.config.getKeyNames(3) + " pour d\u00e9coller";
        this.planeImage.setToolTipText(text);
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int action = this.config.findKeyCode(keyCode);
        if (this.plane != null) {
            if (this.plane.doAction(action)) {
                this.reinit();
            }
        } else {
            switch (action) {
                case 0: 
                case 1: {
                    this.planeIndex += action == 0 ? Pilot.planeConfigs.length - 1 : 1;
                    this.planeIndex %= Pilot.planeConfigs.length;
                    this.displayPlane();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.selectPlane();
                }
            }
        }
    }

    public void displayPlane() {
        this.planeImage.setImage(Pilot.planeConfigs[this.planeIndex].image_photo);
    }

    public void selectPlane() {
        Plane otherPlane;
        PlaneConfig planeConfig = Pilot.planeConfigs[this.planeIndex];
        Plane plane = otherPlane = this == this.pilot.cockpit2 ? this.pilot.cockpit1.plane : this.pilot.cockpit2.plane;
        if (this.pilot.checkCollision(125.0, 0.0, planeConfig, otherPlane)) {
            return;
        }
        this.plane = new Plane(this.pilot, planeConfig, this, this.config.location);
        this.layeredPanel.add((Component)this.plane, this.config.layer);
        this.layeredPanel.add((Component)this.plane.copy, this.config.layer);
        this.updatePlaneToolTip();
        this.wingTriggers[0] = -planeConfig.maxWing;
        this.wingTriggers[1] = planeConfig.maxWing;
        this.wingIndic.repaint();
        this.powerTriggers[0] = -planeConfig.maxPower * 1.0;
        this.powerTriggers[2] = planeConfig.maxPower * 0.75;
        this.powerTriggers[3] = planeConfig.maxPower * 1.0;
        this.powerIndic.repaint();
        this.speedTriggers[1] = planeConfig.maxSpeed * 0.95;
        this.speedTriggers[2] = planeConfig.maxSpeed * 1.25;
        this.speedTriggers[3] = planeConfig.maxSpeed * 2.0;
        this.speedIndic.repaint();
    }

    public void animate() {
        if (this.plane != null) {
            PlaneConfig planeConfig = Pilot.planeConfigs[this.planeIndex];
            this.plane.animate();
            this.altIndic.updateValue(0.0, this.plane.y);
            this.wingIndic.updateValue(-planeConfig.maxWing, -this.plane.wing);
            double moveAngle = -this.plane.moveAngle;
            if (moveAngle < -1.5707963267948966) {
                moveAngle += Math.PI * 2;
            }
            this.angleIndic.updateValue(moveAngle - Math.PI, moveAngle);
            this.powerIndic.updateValue(-planeConfig.maxPower * 1.0, this.plane.power);
            this.speedIndic.updateValue(0.0, this.plane.speed);
        }
    }

    public void reinit() {
        if (this.plane != null) {
            this.layeredPanel.remove(this.plane);
            this.layeredPanel.remove(this.plane.copy);
            this.layeredPanel.repaint();
            this.plane = null;
            this.updatePlaneToolTip();
        }
    }

    private class NamedImage
    extends JPanel {
        private JLabel planeLabel;

        public NamedImage(String name, Image image) {
            this.setLayout(new BoxLayout(this, 1));
            JLabel title = new JLabel(name);
            title.setAlignmentX(0.5f);
            title.setForeground(Color.white);
            title.setFont(new Font("dialog", 1, 9));
            this.add(title);
            JPanel planePanel = new JPanel();
            this.planeLabel = new JLabel(new ImageIcon(image));
            planePanel.add(this.planeLabel);
            planePanel.setBackground(skyColor);
            planePanel.setMinimumSize(new Dimension(80, 40));
            planePanel.setPreferredSize(new Dimension(80, 40));
            this.add(planePanel);
            this.setBackground(Color.black);
        }

        public void setImage(Image image) {
            this.planeLabel.setIcon(new ImageIcon(image));
        }
    }

    private class NamedIndicator
    extends JPanel {
        private Indicator indicator;

        public NamedIndicator(String name, Color color, double[] triggers, Color[] colors, String toolTip) {
            this.setLayout(new BoxLayout(this, 1));
            JLabel title = new JLabel(name);
            title.setAlignmentX(0.5f);
            title.setForeground(Color.white);
            title.setFont(Pilot.indicatorFont);
            this.add(title);
            this.indicator = new Indicator(color, triggers, colors);
            this.indicator.setAlignmentX(0.5f);
            this.add(this.indicator);
            this.setBackground(Color.black);
            this.setToolTipText(toolTip);
        }

        public void updateValue(double lb, double ub) {
            this.indicator.updateValue(lb, ub);
        }
    }

    private class Indicator
    extends JPanel {
        private static final int width = 40;
        private static final int height = 40;
        private final Color valueColor;
        private final double[] triggers;
        private final Color[] colors;
        private double lb;
        private double ub;

        public Indicator(Color valueColor, double[] triggers, Color[] colors) {
            this.valueColor = valueColor;
            this.triggers = triggers;
            this.colors = colors;
            this.lb = triggers[0];
            this.ub = triggers[0];
            this.setPreferredSize(new Dimension(40, 40));
            this.setBackground(Color.black);
        }

        public void updateValue(double lb, double ub) {
            if (this.lb != lb || this.ub != ub) {
                this.lb = lb;
                this.ub = ub;
                this.repaint();
            }
        }

        private Color findColor() {
            int i = 0;
            while (i < this.colors.length - 1) {
                if (this.ub <= this.triggers[i + 1]) {
                    return this.colors[i];
                }
                ++i;
            }
            return this.colors[this.colors.length - 1];
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int vl = (int)(40.0 * (this.lb - this.triggers[0]) / (this.triggers[this.triggers.length - 1] - this.triggers[0]));
            int vu = (int)(40.0 * (this.ub - this.triggers[0]) / (this.triggers[this.triggers.length - 1] - this.triggers[0]));
            g.setColor(this.findColor());
            g.fillRect(1, 0, 39, 40 - vu);
            g.fillRect(1, 40 - vl, 39, vl);
            g.setColor(this.valueColor);
            g.fillRect(1, 40 - vu, 40, vu - vl);
            g.setColor(Color.black);
            g.drawLine(0, 0, 0, 40);
            g.drawLine(0, 10, 40, 10);
            g.drawLine(0, 20, 40, 20);
            g.drawLine(0, 30, 40, 30);
        }
    }
}

